//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Net.Sockets;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla UdpTest.
	/// </summary>
	public class UdpTest : NetworkTest
	{
		public UdpTest(string server, int port, int numberOfPackets, int packetSize) :
			base(server, port, numberOfPackets, packetSize)
		{
		}
		public override void Start()
		{
			Socket client = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

			byte[] writeBuffer = new byte[PacketSize];
			byte[] readBuffer = new byte[PacketSize];
			int nTransmitted;
			int nReceived;
			int nTotalReceived;

			IPAddress address = Dns.Resolve(Server).AddressList[0];
			IPEndPoint remoteEP = new IPEndPoint(address, Port);

			int nBytes;
			// Wysanie losowych bajtw
			nBytes = client.SendTo(writeBuffer, 0, 100, SocketFlags.None, remoteEP);
			EndPoint trEP = (EndPoint)remoteEP;
			nBytes = client.ReceiveFrom(readBuffer, 0, 100, SocketFlags.None, ref trEP);

			// Wykonanie testu
			StartCounters();
			int startTime = Environment.TickCount;
			for(int i = 0; i < NumberOfPackets; i++)
			{
				// nBytes = stream.Write(writeBuffer, 0, writeBuffer.Length);
				nTransmitted = client.SendTo(writeBuffer, 0, PacketSize, SocketFlags.None, remoteEP);
				TransmitByteCount += nTransmitted;
				for(nReceived = 0, nTotalReceived = 0; nTotalReceived < nTransmitted;)
				{
					nReceived = client.ReceiveFrom(readBuffer, nReceived, nTransmitted - nTotalReceived, SocketFlags.None, ref trEP);
					ReceivedByteCount += nReceived;
					nTotalReceived += nReceived;
				}
			}
			int endTime = Environment.TickCount;
			StopCounters();

			Elapsed = endTime - startTime;

			client.Close();
		}
	}
}
